<?php

    /*
     * copyright (c) 2013-2021 Heliac Technologies
     * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
     *
     * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
     * 
     */

    // l'array delle animazioni è usato in tutti i componenti dove devono essere 
    // scelte animazioni (testo, immagine, intestazione ecc)
    $arrayOpzioniSeparatore = array("Nessuno","Sopra","Sotto");
    $arrayOpzioniAllineamento = array(""=>"Sinistra","text-center"=>"Centro","text-right"=>"Destra");
        
    /*
     * serve perché questa popup può essere richiamata dal file creaElemento.php del componente 
     * portfolio, in tal caso bisogna inserire nel percorso "../../"
     */
    $percorsoBase = (isset($contenuto) && $contenuto->getTipo()=="elementoPortfolio") ? "../../" : "";

    $queryComponentiDaMostrare = "SELECT c.id, c.idComponente, cm.nome, c.posizione, c.testo, c.idElemento, c.nomeDaMostrare, c.nomePannello FROM geecB_composizionePannelloLaterale AS c JOIN geecB_componenti AS cm ON c.idComponente=cm.id WHERE nomePannello LIKE 'destra' OR nomePannello LIKE 'sinistra' ORDER BY c.posizione ASC";
    $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);
    while($componente = $risComponenti->fetch_assoc()) {
        
        ?>
        <div class="modal fade" id="configuraComponente<?php echo $componente["id"]; ?>" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Componente <?php echo $componente["nome"] ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form name="formAggiornaComponente<?php echo $componente["id"]; ?>" action="../controller/controllerPannelliLaterali.php" method="post">
                            <input type="text" class="d-none" name="id" value="<?php echo $componente["id"] ?>">
                            <input type="text" class="d-none" name="nomePannello" value="<?php echo $componente["nomePannello"] ?>">
                            <input type="text" class="d-none" name="operazione" value="modificaElemento">
                            
                            <div class="form-group">
                                <label for="url-seo">Nome da mostrare</label>
                                <input type="text" class="form-control" id="url-seo" name="nomeDaMostrare" value="<?php echo $componente["nomeDaMostrare"] ?>" placeholder="Nome da mostrare">
                                <small class="text-muted">Lascia vuoto se non vuoi visualizzare nulla</small>
                            </div>
                            <?php 
                                if($componente["nome"]=="HTML") {
                            ?>
                                    <textarea class="form-control" name="testo" rows="15"><?php echo $componente["testo"] ?></textarea>
                                    <input type="text" class="d-none" name="idElemento" value="0">
                            <?php
                                }
                                else if($componente["nome"]=="Testo") {
                            ?>
                                    <textarea class="tiny"  name="testo" rows="10"><?php echo $componente["testo"] ?></textarea>
                                    <input type="text" class="d-none" name="idElemento" value="0">
                            <?php
                                }
                                else if($componente["nome"]=="Menu") {
                            ?>
                                    <input type="text" class="d-none" name="testo" value="">
                                    <div class="form-group">
                                        <label for="inputPassword3">Scegli il menu</label>
                                        <select class="form-control" name="idElemento">
                                        <?php 
                                            $queryComponentiDaMostrare = "SELECT * FROM geecB_menu";
                                            $risMenu = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                            while($menu = $risMenu->fetch_assoc()) {
                                                $selezionato = "";
                                                if($componente["idElemento"]==$menu["id"]) {
                                                    $selezionato = "selected";
                                                }
                                                echo"<option value=\"{$menu["id"]}\" $selezionato >{$menu["nome"]}</option>";
                                            }
                                        ?>
                                        </select>
                                    </div>
                            <?php
                                }
                                else if($componente["nome"]=="Banner") {
                            ?>
                                    <input type="text" class="d-none" name="testo" value="">
                                    <div class="form-group">
                                        <label for="inputPassword3">Scegli il banner</label>
                                        <select class="form-control" name="idElemento">
                                        <?php 
                                            $queryComponentiDaMostrare = "SELECT * FROM geec_banner";
                                            $risBanner = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                            while($banner = $risBanner->fetch_assoc()) {
                                                $selezionato = "";
                                                if($componente["idElemento"]==$banner["id"]) {
                                                    $selezionato = "selected";
                                                }
                                                echo"<option value=\"{$banner["id"]}\" $selezionato >{$banner["nome"]}</option>";
                                            }
                                        ?>
                                        </select>
                                    </div>
                            <?php
                                }
                                else if($componente["nome"]=="Categoria in evidenza") {
                            ?>
                                    <input type="text" class="d-none" name="testo" value="">
                                    <div class="form-group">
                                        <label for="inputPassword3">Scegli la categoria</label>
                                        <select class="form-control" name="idElemento">
                                            <?php 
                                                $queryComponentiDaMostrare = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo'";
                                                $risBanner = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                                while($categoria = $risBanner->fetch_assoc()) {
                                                    $selezionato = "";
                                                    if($componente["idElemento"]==$categoria["id"]) {
                                                        $selezionato = "selected";
                                                    }
                                                    echo"<option value=\"{$categoria["id"]}\" $selezionato >{$categoria["nome"]}</option>";
                                                }
                                            ?>
                                        </select>
                                    </div>
                            <?php
                                }
                                else { // se non è una delle opzioni precedenti bisogna mettere questi campi nascosti
                            ?>
                                    <input type="text" class="d-none" name="idElemento" value="0">
                                    <input type="text" class="d-none" name="testo" value="">
                            <?php
                                }
                            ?>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="document.formAggiornaComponente<?php echo $componente["id"]; ?>.submit()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }